package middleware

import (
	"fmt"
	"net/http"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
)

type Middleware struct {
	logger log.Logger
}

func New(logger log.Logger) *Middleware {
	h := &Middleware{
		logger: logger,
	}
	return h
}

func (m *Middleware) Logger(next http.Handler) http.Handler {
	fn := func(w http.ResponseWriter, r *http.Request) {
		t := time.Now()
		defer func() {
			ctxlog.Info(r.Context(), m.logger, "access",
				log.Time("time", t),
				log.Duration("duration", time.Since(t)),
				log.String("uri", r.RequestURI),
				log.String("remote", r.RemoteAddr),
			)
		}()
		next.ServeHTTP(w, r)
	}
	return http.HandlerFunc(fn)
}

func (m *Middleware) Recover(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, req *http.Request) {
		defer func() {
			if r := recover(); r != nil {
				w.WriteHeader(http.StatusInternalServerError)
				errorMessage := fmt.Sprintf("An error is caught: %+v", r)
				ctxlog.Error(req.Context(), m.logger, errorMessage)
			}
		}()
		next.ServeHTTP(w, req)
	})
}
