package server

import (
	"fmt"
	"net/http"

	"github.com/opentracing/opentracing-go"

	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/utils"
)

func (server *Server) Proxy(w http.ResponseWriter, r *http.Request) {
	proxySpan, _ := opentracing.StartSpanFromContext(r.Context(), "Proxy")
	defer proxySpan.Finish()

	server.app.Logger.Info(fmt.Sprintf("request URL: %v", r.URL))
	query := r.URL.Query()

	clientGeoid := utils.ReadIntParameter(query.Get("geo_id"))
	if clientGeoid == -1 {
		w.WriteHeader(400)
		_, err := w.Write([]byte("Geoid is not a number"))
		if err != nil {
			server.app.Logger.Error(fmt.Sprintf("Cannot write answer: %v", err))
		}
		return
	}

	settlement, found := server.app.Storage.SettlementRepo.Get(clientGeoid)
	if !found {
		w.WriteHeader(400)
		_, err := w.Write([]byte("Geoid does not exist"))
		if err != nil {
			server.app.Logger.Error(fmt.Sprintf("Cannot write answer: %v", err))
		}
		return
	}
	w.WriteHeader(200)
	_, err := w.Write([]byte(fmt.Sprintf("Found settlement with title=%v", settlement.TitleDefault)))
	if err != nil {
		server.app.Logger.Error(fmt.Sprintf("Cannot write answer: %v", err))
	}
}
