package storage

import (
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/repository"
)

func (storage *Storage) LoadCountry(logger *zap.Logger) {
	path := "/home/evpavlyuk/poc/country.data" // TODO: make correct path

	bytesIterator, err := base.BuildIteratorFromFile(path)
	if err != nil {
		logger.Fatalf("Error while creating iterator %v\n", err)
		logger.Fatalf("Please ensure thats file with data is in place: %s\n", path)
	}

	storage.CountryRepo = repository.NewCountryRepository()
	err = bytesIterator.Populate(storage.CountryRepo)
	if err != nil {
		logger.Fatalf("Error while populating repository %v", err)
	}

	_, found := storage.CountryRepo.Get(225)
	if !found {
		logger.Fatalf("Something goes wrong, no sample country :(")
	}
}
