package storage

import (
	"errors"

	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/geomodel"
)

func (storage *Storage) LoadSettlement(logger *zap.Logger) {
	path := "/home/evpavlyuk/poc/settlement.data" // TODO: make correct path

	bytesIterator, err := base.BuildIteratorFromFile(path)
	if err != nil {
		logger.Fatalf("Error while creating iterator %v\n", err)
		logger.Fatalf("Please ensure thats file with data is in place: %s\n", path)
	}

	storage.SettlementRepo = repository.NewSettlementRepository()
	err = bytesIterator.Populate(storage.SettlementRepo)
	if err != nil {
		logger.Fatalf("Error while populating repository %v", err)
	}

	_, found := storage.SettlementRepo.Get(213)
	if !found {
		logger.Fatalf("Something goes wrong, no Moscow :(")
	}
}

func (storage *Storage) GetSettlementByID(id int, ignoreHidden bool) (*geomodel.Settlement, error) {
	settlement, found := storage.SettlementRepo.Get(id)
	if !found || (ignoreHidden && settlement.IsHidden) {
		return nil, errors.New("point was not found")
	}

	return &geomodel.Settlement{TSettlement: settlement}, nil
}

func (storage *Storage) GetSettlementByGeoID(geoid int, ignoreHidden bool) (*geomodel.Settlement, error) {
	settlement, found := storage.SettlementRepo.Get(geoid) // TODO: it's wrong for 50k settlements, need new map
	if !found || (ignoreHidden && settlement.IsHidden) {
		return nil, errors.New("point was not found")
	}

	return &geomodel.Settlement{TSettlement: settlement}, nil
}
