package storage

import (
	"errors"

	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/geomodel"
)

func (storage *Storage) LoadStation(logger *zap.Logger) {
	path := "/home/evpavlyuk/poc/station.data" // TODO: make correct path

	bytesIterator, err := base.BuildIteratorFromFile(path)
	if err != nil {
		logger.Fatalf("Error while creating iterator %v\n", err)
		logger.Fatalf("Please ensure thats file with data is in place: %s\n", path)
	}

	storage.StationRepo = repository.NewStationRepository()
	err = bytesIterator.Populate(storage.StationRepo)
	if err != nil {
		logger.Fatalf("Error while populating repository %v", err)
	}

	_, found := storage.StationRepo.Get(2000001)
	if !found {
		logger.Fatalf("Something goes wrong, no sample station")
	}
}

func (storage *Storage) GetStationByID(id int, ignoreHidden bool) (*geomodel.Station, error) {
	station, found := storage.StationRepo.Get(id)
	if !found || (ignoreHidden && station.IsHidden) {
		return nil, errors.New("point was not found")
	}

	return &geomodel.Station{TStation: station}, nil
}
