package storage

import (
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/geomodel"
)

func (storage *Storage) GetCachedStations() []*geomodel.Station { // TODO dummy, move to stations
	return []*geomodel.Station{}
}

func (storage *Storage) LoadStationsBySettlement(logger *zap.Logger) {
	stations := storage.GetCachedStations()
	storage.Settlement2Stations = make(map[TPointID]TStations, len(stations))
	for _, s := range stations {
		id, err := s.GetSettlementID()
		if err == nil { // TODO: do we need do something with stations without SettlementID?
			stations, found := storage.Settlement2Stations[TPointID(id)] // TODO change int type to TPointID everywhere
			if !found {
				stations = []*geomodel.Station{}
			}
			storage.Settlement2Stations[TPointID(id)] = append(stations, s)
		}
	}
}

func (storage *Storage) GetStationsBySettlement(point geomodel.Point) ([]*geomodel.Station, bool) {
	stations, found := storage.Settlement2Stations[TPointID(point.GetID())]
	if !found {
		return []*geomodel.Station{}, false
	}
	return stations, true

	// TODO: if cache is nil, do we need it?  return settlement.station_set.filter(hidden=False)
}
