package storage

import (
	"errors"

	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/geomodel"
)

type TPointID int
type TStations []*geomodel.Station

type Storage struct {
	CountryRepo            *repository.CountryRepository
	DefaultPointRepo       *DefaultPoint
	NameSearcher           NameSearchIndex
	RegionRepo             *repository.RegionRepository
	SettlementRepo         *repository.SettlementRepository
	StationRepo            *repository.StationRepository
	Settlement2Stations    map[TPointID]TStations
	ExternalDirectionCache map[int]ExternalDirectionData
}

func (storage *Storage) LoadRepositories(logger *zap.Logger) {
	storage.LoadSettlement(logger)
	storage.LoadStation(logger)
	storage.LoadCountry(logger)
	storage.LoadRegion(logger)

	storage.LoadStationsBySettlement(logger)
}

func (storage *Storage) GetPointByID(pointID int, pointType geomodel.PointType, ignoreHidden bool) (geomodel.Point, error) {
	var err error
	switch pointType {
	case geomodel.ESettlement:
		s, err := storage.GetSettlementByID(pointID, ignoreHidden)
		if err != nil {
			return geomodel.Point(s), err
		}
	case geomodel.EStation:
		s, err := storage.GetStationByID(pointID, ignoreHidden)
		if err != nil {
			return geomodel.Point(s), err
		}
	default:
		return nil, errors.New("not applicable")
	}
	return nil, err
}
