#!/usr/bin/env python2
# coding: utf8

import urlparse

from nginx_log_normalize_functions import nginx_log_normalize_uri

paths = [
    'api/proxy',
    'public-api/proxy',
    'public-api/ping',
    'public-api/version',
]

def nginx_log_normalize_record(record):
    title = nginx_log_normalize_uri(paths, record.uri)
    if title != 'public-api/proxy' and title != 'api/proxy':
        return title
    args = urlparse.parse_qs(record.args)
    transport = args.get('transport')
    tag = (
        'direction/{}/{}'.format(
            'blank'
            if transport and transport not in ('bus', 'suburban',) else
            'bus+suburban',
            'with_date' if args.get('departure_date') else 'without_date'
        ) if (
            (args.get('point') and args.get('point_to')) or
            (args.get('departure_settlement_geoid') and args.get('arrival_settlement_geoid'))
        ) else 'station/{}/{}'.format(
            'plane' if args.get('transport') == 'plane' else 'suburban',
            'with_date' if args.get('departure_date') else 'without_date'
        ) if args.get('point') else (
            'general'
            if args.get('geo_id') else
            'unknown'
        )
    )
    return 'api/proxy/?_query=' + tag
