# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import sys

from jaeger_client import Config
from travel.library.python.tracing.django import Tracing
from travel.library.python.tracing.gunicorn import build_post_fork

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "travel.rasp.wizards.proxy_api.docker.local_settings")

sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from travel.rasp.library.python.common23.server.gunicorn.default import *  # noqa: ImportStarUsed

bind = "unix:/tmp/proxy-api.sock"
workers = os.environ.get('PROXY_API_GUNICORN_WORKERS', 2)

# (when_ready из travel.rasp.library.python.common23.server.gunicorn.default)
_default_when_ready = when_ready  # noqa: ImportStarUsage

jaeger_sampler_type = os.environ.get('JAEGER_SAMPLER_TYPE', 'probabilistic')
jaeger_sampler_parameter = float(os.environ.get('JAEGER_SAMPLER_PARAMETER', 0.001))
jaeger_config = Config(
    config={
        'sampler': {
            'type': jaeger_sampler_type,
            'param': jaeger_sampler_parameter,
        },
        'logging': True,
    },
    service_name='wizard-proxy-api',
    validate=True,
)


def when_ready(server):
    from travel.rasp.wizards.wizard_lib.utils.timestamp_checker import setup_timestamped_recache

    _default_when_ready(server)
    setup_timestamped_recache(code='prepare_all', logger=server.log)


post_fork = build_post_fork(jaeger_config, wrapper_cls=Tracing)
