# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings
from django.utils.http import urlencode


def _format_direction_params(query, query_params):
    return urlencode(
        (parameter, value)
        for parameter, value in (
            ('exp_flags', query_params.get('exp_flags') or None),
            ('reqid', query_params.get('reqid') or None),
            ('main_reqid', query_params.get('main_reqid') or None),
            ('departure_point_key', query.departure_point.point_key),
            ('arrival_point_key', query.arrival_point.point_key),
            ('departure_date', query.departure_date),
            ('thread_number', query.thread_number),
            ('thread_express_type', query.thread_express_type and query.thread_express_type.value),
            ('lang', query.language),
            ('limit', query.limit),
            ('tld', query.tld),
        )
        if value is not None
    )


def format_bus_direction_url(query, query_params):
    return b'{}?{}'.format(settings.PROXY_API_BUS_DIRECTION_URL, _format_direction_params(query, query_params))


def format_suburban_direction_url(query, query_params):
    return b'{}?{}'.format(settings.PROXY_API_SUBURBAN_DIRECTION_URL, _format_direction_params(query, query_params))


def _format_station_params(query, query_params):
    return urlencode(
        (parameter, value)
        for parameter, value in (
            ('exp_flags', query_params.get('exp_flags') or None),
            ('reqid', query_params.get('reqid') or None),
            ('station_id', query.station.id),
            ('event_date', query.event_date),
            ('lang', query.language),
            ('tld', query.tld),
        )
        if value is not None
    )


def format_suburban_station_url(query, query_params):
    return b'{}?{}'.format(settings.PROXY_API_SUBURBAN_STATION_URL, _format_station_params(query, query_params))
