# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.rasp.wizards.proxy_api.lib.direction.models import AggregatedDirectionData


def aggregate_direction_data(direction_data):
    segments = direction_data.segments
    segment_prices = filter(None, (segment.price for segment in segments))
    return AggregatedDirectionData(
        found_departure_date=segments[0].departure_local_dt.date(),
        minimum_duration=min(segment.arrival_local_dt - segment.departure_local_dt for segment in segments),
        minimum_price=min(segment_prices) if segment_prices else None,
        **direction_data._asdict()
    )
