# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple

from travel.rasp.wizards.proxy_api.lib.segments.models import BaseSegment


DirectionQuery = namedtuple('DirectionQuery', (
    'departure_point',
    'arrival_point',
    'transport_code',
    'departure_date',
    'thread_express_type',
    'thread_number',
    'language',
    'experiment_flags',
    'tld',
    'limit',
    'main_reqid',
))

Segment = namedtuple('Segment', BaseSegment._fields + ('price',))

DirectionData = namedtuple('DirectionData', ('segments', 'total',))

AggregatedDirectionData = namedtuple('AggregatedDirectionData', DirectionData._fields + (
    'found_departure_date', 'minimum_duration', 'minimum_price'
))
