# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from rest_framework import serializers

from travel.rasp.wizards.proxy_api.lib.general.models import GeneralQuery
from travel.rasp.wizards.wizard_lib.serialization.date import parse_date
from travel.rasp.wizards.wizard_lib.serialization.intent_type import parse_intent
from travel.rasp.wizards.wizard_lib.serialization.language import parse_language


def load_general_query(departure_settlement, experiment_flags, query_params):
    try:
        intent = parse_intent(query_params.get('query'))
    except serializers.ValidationError:
        intent = None

    return GeneralQuery(
        departure_settlement=departure_settlement,
        transport_code=query_params.get('transport') or None,
        departure_date=parse_date(query_params.get('date'), departure_settlement.pytz),
        language=parse_language(query_params.get('lang')),
        experiment_flags=experiment_flags,
        intent=intent,
        tld=query_params.get('tld'),
    )
