# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple

from enum import Enum

from travel.rasp.wizards.proxy_api.lib.segments.models import BaseSegment


class EventUpdateStatus(Enum):
    UNKNOWN = 'unknown'
    CANCELLED = 'cancelled'
    ARRIVED = 'arrived'
    DEPARTED = 'departed'
    DELAYED = 'delayed'
    EARLY = 'early'
    ON_TIME = 'on_time'


SuburbanStationQuery = namedtuple(
    'SuburbanStationQuery', 'station, event_date, language, experiment_flags, tld'
)
PlaneStationQuery = namedtuple(
    'PlaneStationQuery', 'station, event_date, direction_type, language, experiment_flags, tld'
)

SuburbanSegment = namedtuple('SuburbanSegment', BaseSegment._fields + ('platform', 'stops',))
PlaneSegment = namedtuple(
    'PlaneSegment', BaseSegment._fields + ('departure_terminal', 'arrival_terminal', 'event_update',)
)
EventUpdate = namedtuple('EventUpdate', 'event_dt, terminal, gate, status, baggage_carousels, check_in_desks')

SuburbanDirection = namedtuple('SuburbanDirection', 'type, code, total, segments')
PlaneDirection = namedtuple('PlaneDirection', 'type, total, segments')

StationData = namedtuple('StationData', 'directions')
