# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.utils.encoding import force_bytes
from enum import Enum


class TrackingParameter(Enum):
    DIRECTION = 'wrasppp'
    GENERAL = 'wraspgeneral'
    PLANE_STATION = 'wraspstatus'
    SUBURBAN_STATION = 'wraspstation'


def get_tracking_query_item(parameter):
    return (b'from', force_bytes(parameter.value))


def get_tracking_query_parameter(parameter):
    return b'='.join(get_tracking_query_item(parameter))


def add_tracking_parameter(url, parameter):
    return force_bytes('{url}{sep}{query}'.format(
        url=url, sep=('&' if '?' in url else '?'), query=get_tracking_query_parameter(parameter)
    ))
