# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings
from django.conf.urls import url
from django.conf.urls.static import static

from travel.rasp.wizards.proxy_api.views.geosearch import geosearch_view
from travel.rasp.wizards.proxy_api.views.proxy import proxy_view
from travel.rasp.wizards.proxy_api.views.station_search import station_search_view
from travel.rasp.wizards.wizard_lib.views.ping import ping_view
from travel.rasp.wizards.wizard_lib.views.version import version_view

urlpatterns = [
    url(r'^api/proxy/$', proxy_view),
    url(r'^public-api/proxy/$', proxy_view),  # FIXME
    url(r'^public-api/geosearch/$', geosearch_view),  # FIXME
    url(r'^public-api/station_search/$', station_search_view),  # FIXME
    url(r'^public-api/ping/$', ping_view),
    url(r'^public-api/version/$', version_view),
]

urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
