# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.utils.encoding import force_text
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.wizards.proxy_api.lib.direction.points import PointsException, find_points
from travel.rasp.wizards.wizard_lib.serialization.point import dump_point


@api_view()
def geosearch_view(request):
    query_params = request.query_params
    client_geoid = query_params.get('geo_id')
    transport_code = query_params.get('transport')
    departure_point_name = query_params.get('point')
    departure_settlement_geoid = query_params.get('departure_settlement_geoid')
    arrival_point_name = query_params.get('point_to')
    arrival_settlement_geoid = query_params.get('arrival_settlement_geoid')

    try:
        departure_point, arrival_point = find_points(
            departure_settlement_geoid=departure_settlement_geoid,
            departure_point_name=departure_point_name,
            arrival_settlement_geoid=arrival_settlement_geoid,
            arrival_point_name=arrival_point_name,
            client_geoid=client_geoid,
            transport_code=transport_code
        )
    except PointsException as error:
        return Response({'error': force_text(error[0][0])})

    return Response({'departure_point': dump_point(departure_point), 'arrival_point': dump_point(arrival_point)})
