# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from rest_framework import status
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.wizards.proxy_api.lib.logger import log_run_time
from travel.rasp.wizards.proxy_api.lib.router import get_response
from travel.rasp.wizards.wizard_lib.utils.yasm_metric_manager import YasmMetricManager

logger = logging.getLogger(__name__)
yasm_metric_manager = YasmMetricManager(__name__, logger)


@api_view()
def proxy_view(request):
    yasm_metric_manager.send_one('request_cnt')

    with log_run_time(' processing request: {}'.format(request)):
        response = get_response(request.query_params)

    if response:
        yasm_metric_manager.send_one('with_data_cnt')
        return response

    yasm_metric_manager.send_one('no_data_cnt')
    return Response(status=status.HTTP_204_NO_CONTENT, headers={'Content-Length': 0})
