# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import six

from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.wizards.proxy_api.lib.station.search import find_station
from travel.rasp.wizards.wizard_lib.serialization.point import dump_point


@api_view()
def station_search_view(request):
    query_params = request.query_params

    try:
        station = find_station(
            query_params.get('point'),
            query_params.get('transport') or 'suburban',
            query_params.get('geo_id') or None
        )
    except Exception as error:
        return Response({'error': six.text_type(error)})

    station_dump = dump_point(station)
    if station_dump is not None:
        station_dump = dict(station_dump, **{'t_type_code': station.t_type.code})

    return Response({'station': station_dump})
