PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/django-opentracing
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/jaeger-client

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation

    travel/rasp/library/python/common
    travel/rasp/library/python/geosearch
    travel/library/python/entrypoint

    travel/rasp/wizards/suburban_wizard_api
    travel/rasp/wizards/wizard_lib
)

PY_SRCS(
    __init__.py
    app.py
    docker/local_settings.py
    gunicorn_conf.py

    lib/api_urls.py
    lib/direction/__init__.py
    lib/direction/aggregation.py
    lib/direction/formats.py
    lib/direction/models.py
    lib/direction/points.py
    lib/direction/serialization.py
    lib/general/__init__.py
    lib/general/formats.py
    lib/general/models.py
    lib/general/serialization.py
    lib/__init__.py
    lib/logger.py
    lib/query_parsing.py
    lib/requests_pool.py
    lib/router.py
    lib/segments/__init__.py
    lib/segments/models.py
    lib/segments/serialization.py
    lib/station/__init__.py
    lib/station/formats.py
    lib/station/models.py
    lib/station/search.py
    lib/station/serialization.py
    lib/station/settlement_stations_cache.py
    lib/tests_utils.py
    lib/tracking.py

    manage.py

    settings/__init__.py
    settings/api_urls.py

    urls/__init__.py

    views/__init__.py
    views/geosearch.py
    views/proxy.py
    views/station_search.py

    wsgi.py
)

RESOURCE_FILES(
    PREFIX travel/rasp/wizards/proxy_api
    templates/direction.j2
    templates/direction_bus.j2
    templates/direction_suburban_express.j2
    templates/direction_suburban.j2
    templates/direction_suburban_aeroexpress.j2
    templates/plane_station.j2
    templates/suburban_station.j2

    docker/Dockerfile
    docker/logrotate/app.conf
    docker/pre_start/nginx_01_tvm
    docker/pre_start/hosts_patch
    docker/supervisor/10-app.conf
    docker/solomon/modules/nginx_log_normalize_path.py
    docker/nginx/50-app.conf
)

NO_LINT(
    docker/local_settings/__init__.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)

