# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import Counter

from common.models.transport import TransportType
from travel.rasp.wizards.wizard_lib.direction.logger import DirectionLogger


def adapt_suburban_direction_segments(segments):
    segment_counts = Counter({
        'all': len(segments),
        'without_price_info': 0,
        'with_price': 0,
    })

    for segment in segments:
        segment_counts['with_price' if segment.price is not None else 'without_price_info'] += 1

    return {'{}_segments_count'.format(category): count for category, count in segment_counts.iteritems()}


suburban_direction_logger = DirectionLogger(
    defaults={'transport_type_id': TransportType.SUBURBAN_ID},
    segments_adapter=adapt_suburban_direction_segments
)
