# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from functools import partial

from django.http import HttpResponse
from google.protobuf import json_format

JsonResponse = partial(HttpResponse, content_type='application/json')


def proto_view(content_type):
    def decorator(func):
        def decorated(request, *args, **kwargs):
            debug_json = bool(request.GET.get('json'))
            response = func(request=request, *args, **kwargs)

            if response is None:
                return (
                    HttpResponse(status=204)
                    if not debug_json else
                    JsonResponse('{"error": "segments not found"}')
                )

            return (
                HttpResponse(response.SerializeToString(), content_type=content_type)
                if not debug_json else
                JsonResponse(json_format.MessageToJson(response))
            )

        decorated.__name__ = func.__name__
        return decorated

    return decorator
