# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.library.python.tracing.instrumentation import traced_function

from travel.rasp.wizards.suburban_wizard_api.lib.direction.filters import Filters
from travel.rasp.wizards.suburban_wizard_api.lib.serialization.points import parse_points
from travel.rasp.wizards.wizard_lib.serialization.date import parse_date
from travel.rasp.wizards.wizard_lib.serialization.direction import DirectionQuery, parse_sorting
from travel.rasp.wizards.wizard_lib.serialization.experiment_flags import parse_experiment_flags
from travel.rasp.wizards.wizard_lib.serialization.language import parse_language
from travel.rasp.wizards.wizard_lib.serialization.point import dump_point


def _dump_datetime(local_dt):
    return {'value': local_dt.isoformat(), 'timezone': local_dt.tzinfo.zone}


def _dump_price(price):
    return {'value': price.value, 'currency': price.currency} if price is not None else None


def dump_segment(segment, lang):
    return {
        'train': {  # TODO: departure, arrival
            'number': segment.train_number,
            'title': getattr(segment.train_title, lang),
        },
        'departure': {
            'station': dump_point(segment.departure_station),
            'settlement': dump_point(segment.departure_station.settlement),
            'local_datetime': _dump_datetime(segment.departure_local_dt),
        },
        'arrival': {
            'station': dump_point(segment.arrival_station),
            'settlement': dump_point(segment.arrival_station.settlement),
            'local_datetime': _dump_datetime(segment.arrival_local_dt),
        },
        'price': _dump_price(segment.price)
    }


@traced_function
def load_query(query_params):
    departure_point, arrival_point = parse_points(query_params)
    return DirectionQuery(
        departure_point=departure_point,
        arrival_point=arrival_point,
        departure_date=parse_date(query_params.get('departure_date'), departure_point.pytz),
        language=parse_language(query_params.get('language')),
        experiment_flags=parse_experiment_flags(query_params.get('exp_flags')),
        sorting=parse_sorting(query_params.get('order_by')),
        filters=Filters.load(query_params),
        tld=query_params.get('tld'),
    )
