# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple

from travel.library.python.tracing.instrumentation import traced_function

from travel.rasp.wizards.suburban_wizard_api.lib.serialization.limit import parse_limit
from travel.rasp.wizards.wizard_lib.serialization.date import parse_date
from travel.rasp.wizards.wizard_lib.serialization.experiment_flags import parse_experiment_flags
from travel.rasp.wizards.wizard_lib.serialization.language import parse_language
from travel.rasp.wizards.wizard_lib.serialization.point import parse_point_key
from travel.rasp.wizards.wizard_lib.serialization.thread_express_type import parse_thread_express_type


DirectionQuery = namedtuple('DirectionQuery', (
    'departure_point',
    'arrival_point',
    'departure_date',
    'thread_express_type',
    'thread_number',
    'language',
    'tld',
    'experiment_flags',
    'limit',
    'main_reqid',
))


@traced_function
def load_query(query_params):
    departure_point = parse_point_key(query_params, 'departure_point_key')
    arrival_point = parse_point_key(query_params, 'arrival_point_key')
    main_reqid = query_params.get('main_reqid') or None

    return DirectionQuery(
        departure_point=departure_point,
        arrival_point=arrival_point,
        departure_date=parse_date(query_params.get('departure_date'), departure_point.pytz),
        thread_number=query_params.get('thread_number') or None,
        thread_express_type=parse_thread_express_type(query_params.get('thread_express_type')),
        language=parse_language(query_params.get('lang')),
        experiment_flags=parse_experiment_flags(query_params.get('exp_flags')),
        tld=query_params.get('tld'),
        limit=parse_limit(query_params.get('limit')),
        main_reqid=main_reqid,
    )
