# -*- coding: utf-8 -*-

from django.conf import settings
from django.conf.urls import url
from django.conf.urls.static import static

from travel.rasp.wizards.suburban_wizard_api.views.direction import direction_view
from travel.rasp.wizards.suburban_wizard_api.views.legacy_direction import legacy_direction_view
from travel.rasp.wizards.suburban_wizard_api.views.proto_direction import proto_direction_view
from travel.rasp.wizards.suburban_wizard_api.views.proto_station import proto_station_view
from travel.rasp.wizards.wizard_lib.views.ping import ping_view
from travel.rasp.wizards.wizard_lib.views.version import version_view

urlpatterns = [
    url(r'^api/direction/$', direction_view),
    url(r'^api/legacy_direction/$', legacy_direction_view),
    url(r'^api/proto_direction/$', proto_direction_view),
    url(r'^api/proto_station/$', proto_station_view),
    url(r'^public-api/direction/$', direction_view),  # FIXME
    url(r'^public-api/legacy_direction/$', legacy_direction_view),  # FIXME
    url(r'^public-api/proto_direction/$', proto_direction_view),  # FIXME
    url(r'^public-api/proto_station/$', proto_station_view),  # FIXME
    url(r'^public-api/ping/$', ping_view),
    url(r'^public-api/version/$', version_view),
]

urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
