# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.library.python.tracing.django import traced_view
from travel.rasp.wizards.suburban_wizard_api.lib.direction.segments import make_next_query, make_segments
from travel.rasp.wizards.suburban_wizard_api.lib.proto_view import proto_view
from travel.rasp.wizards.suburban_wizard_api.lib.schedule_cache import schedule_cache
from travel.rasp.wizards.suburban_wizard_api.lib.serialization.proto_direction import load_query
from travel.rasp.wizards.wizard_lib.direction.segments import find_schedule_segments
from travel.rasp.wizards.wizard_lib.serialization.proto_direction import dump_segments
from travel.rasp.wizards.wizard_lib.serialization.thread_express_type import ThreadExpressType


def _make_thread_predicate(query):
    predicates = []

    number = query.thread_number
    if number:
        predicates.append((lambda thread: thread.number == number))

    express_type = query.thread_express_type
    if express_type:
        express_type_value = express_type.value
        predicates.append((lambda thread: thread.express_type == express_type_value))

    return (
        None if not predicates else
        predicates[0] if len(predicates) == 1 else
        (lambda thread: all(predicate(thread) for predicate in predicates))
    )


@traced_view()
@proto_view('application/x-suburban-direction')
def proto_direction_view(request):
    query = load_query(request.GET)

    departure_date_query = make_next_query(query.departure_date, query.departure_point.pytz)

    found_departure_date, raw_segments = find_schedule_segments(
        schedule_cache, query.departure_point, query.arrival_point, departure_date_query,
        thread_predicate=_make_thread_predicate(query),
    )

    if not raw_segments and query.thread_express_type == ThreadExpressType.AEROEXPRESS:
        no_aeroexpress_query = query._replace(thread_express_type=None)
        found_departure_date, raw_segments = find_schedule_segments(
            schedule_cache,
            no_aeroexpress_query.departure_point,
            no_aeroexpress_query.arrival_point,
            departure_date_query,
            thread_predicate=_make_thread_predicate(no_aeroexpress_query),
        )

    if raw_segments:
        segments = make_segments(raw_segments)
        return dump_segments(segments, query)
