# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.library.python.tracing.django import traced_view
from travel.rasp.wizards.suburban_wizard_api.lib.proto_view import proto_view
from travel.rasp.wizards.suburban_wizard_api.lib.serialization.proto_station import dump_station_response, load_query
from travel.rasp.wizards.suburban_wizard_api.lib.station.segments_search import find_directions_with_segments
from travel.rasp.wizards.wizard_lib.experiment_flags import ExperimentFlag

SEGMENTS_LIMIT = 5


@traced_view()
@proto_view('application/x-suburban-station')
def proto_station_view(request):
    query = load_query(request.GET)

    raw_directions = find_directions_with_segments(
        query.station,
        query.event_date,
        hacked_future=(ExperimentFlag.SUBURBAN_STATION_HACKED_FUTURE in query.experiment_flags)
    )

    if raw_directions:
        return dump_station_response(raw_directions, query, segments_limit=SEGMENTS_LIMIT)
