PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/drf-ujson
    contrib/python/django-opentracing
    contrib/python/djangorestframework
    contrib/python/httpretty
    contrib/python/python-json-logger

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation
    travel/library/python/tracing/sampling

    travel/rasp/library/python/common
    travel/rasp/library/python/geosearch
    travel/library/python/entrypoint

    travel/rasp/wizards/wizard_lib
)

PY_SRCS(
    __init__.py
    app.py
    gunicorn_conf.py

    lib/direction/__init__.py
    lib/direction/filters.py
    lib/direction/logger.py
    lib/direction/segments.py
    lib/direction/tariffs_cache.py
    lib/__init__.py
    lib/proto_view.py
    lib/schedule_cache.py
    lib/serialization/__init__.py
    lib/serialization/direction.py
    lib/serialization/legacy_direction.py
    lib/serialization/limit.py
    lib/serialization/points.py
    lib/serialization/proto_direction.py
    lib/serialization/proto_station.py
    lib/station/__init__.py
    lib/station/segments_search.py
    lib/station/suburban_directions_cache.py
    lib/tests_utils.py

    manage.py
    settings/__init__.py

    urls/__init__.py

    views/__init__.py
    views/direction.py
    views/legacy_direction.py
    views/proto_direction.py
    views/proto_station.py

    wsgi.py
)

NO_LINT(
    docker/local_settings/__init__.py
)

RESOURCE_FILES(
    PREFIX travel/rasp/wizards/suburban_wizard_api
    lib/direction/texts.j2
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
