# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.wizards.train_wizard_api.direction.filters.coach_type_filter import CoachTypeFilter
from travel.rasp.wizards.train_wizard_api.direction.filters.facility_filter import FacilityFilter
from travel.rasp.wizards.train_wizard_api.direction.filters.place_count_filter import PlaceCountFilter
from travel.rasp.wizards.train_wizard_api.direction.filters.price_filter import PriceFilter
from travel.rasp.wizards.train_wizard_api.direction.filters.brand_filter import BrandFilter
from travel.rasp.wizards.wizard_lib.direction.filters import (
    DepartureTimeFilter, ArrivalTimeFilter, BaseFilters
)


class Filters(BaseFilters):
    FACTORIES = (
        ('departure_time', DepartureTimeFilter.load),
        ('arrival_time', ArrivalTimeFilter.load),
        ('brand', BrandFilter.load),
        ('coach_type', CoachTypeFilter.load),
        ('price', PriceFilter.load),
        ('place_count', PlaceCountFilter.load),
        ('facility', FacilityFilter.load)
    )

    def get_brand_filter(self):
        return self._filters[2]
