# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import Counter

from common.models.transport import TransportType
from travel.rasp.wizards.wizard_lib.direction.logger import DirectionLogger, dump_datetime


def adapt_train_direction_segments(segments):
    segment_counts = Counter({
        'all': len(segments),
        'sold_out': 0,
        'without_price_info': 0,
        'with_price': 0,
    })
    updated_at_records = []
    for segment in segments:
        places, updated_at = segment.places, segment.updated_at

        if places is None:
            segment_counts['sold_out' if updated_at is not None else 'without_price_info'] += 1
        else:
            segment_counts['with_price'] += 1
            for place in places:
                segment_counts[place.coach_type] += 1

        if updated_at is not None:
            updated_at_records.append(updated_at)

    result = {'{}_segments_count'.format(category): count for category, count in segment_counts.items()}

    min_updated_at = None
    max_updated_at = None
    if updated_at_records:
        min_updated_at = min(updated_at_records)
        max_updated_at = max(updated_at_records)
    result.update({'min_updated_at': dump_datetime(min_updated_at), 'max_updated_at': dump_datetime(max_updated_at)})

    return result


direction_logger = DirectionLogger(
    defaults={'transport_type_id': TransportType.TRAIN_ID, 'view': 'default'},
    segments_adapter=adapt_train_direction_segments
)
legacy_direction_logger = DirectionLogger(
    defaults={'transport_type_id': TransportType.TRAIN_ID, 'view': 'legacy'},
    segments_adapter=adapt_train_direction_segments
)
open_direction_logger = DirectionLogger(
    defaults={'transport_type_id': TransportType.TRAIN_ID, 'view': 'open'},
    segments_adapter=adapt_train_direction_segments
)
