# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import heapq
import itertools
from collections import namedtuple

PROMOTION_LIMIT = 2

Promotion = namedtuple('Promotion', ('value', 'apply',))


def promote_by_brand(segments):
    promoted_indexes = set(itertools.islice(
        (i for (i, segment) in enumerate(segments) if segment.places and segment.train_brand is not None),
        PROMOTION_LIMIT
    ))
    if not promoted_indexes:
        return segments

    promoted_segments = []
    other_segments = []

    for (i, segment) in enumerate(segments):
        segments_group = promoted_segments if i in promoted_indexes else other_segments
        segments_group.append(segment)

    return tuple(itertools.chain(promoted_segments, other_segments))


def promote_by_duration(segments):
    promoted_with_indexes = heapq.nsmallest(
        PROMOTION_LIMIT,
        ((i, segment) for (i, segment) in enumerate(segments) if segment.places),
        key=lambda (i, segment): segment.duration
    )
    if not promoted_with_indexes:
        return segments

    promoted_indexes_list, promoted_segments = zip(*promoted_with_indexes)
    promoted_indexes = set(promoted_indexes_list)

    return tuple(itertools.chain(promoted_segments, (
        segment for (i, segment) in enumerate(segments) if i not in promoted_indexes
    )))


BRAND_PROMOTION = Promotion('brand', promote_by_brand)
DURATION_PROMOTION = Promotion('duration', promote_by_duration)
NULL_PROMOTION = Promotion(None, lambda segments: segments)
