# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from functools import partial

import travel.rasp.wizards.wizard_lib.direction.sorting as common_sorting


def _best_train_offers_sorting_key(variant):
    places_group, segment = variant.places_group, variant.segment
    return (
        # дорогие поезда хуже дешёвых и поезда без цен хуже поездов с ценами
        places_group.price if places_group is not None else float('inf'),
        # поезда, которые отправляются или прибывают ночью (00:00 - 06:00), хуже остальных
        segment.departure_local_dt.hour < 6 or segment.arrival_local_dt.hour < 6
    )


BEST_TRAIN_OFFERS_SORTING = common_sorting.Sorting(
    'best', partial(sorted, key=_best_train_offers_sorting_key)
)

SORTINGS = dict(common_sorting.SORTINGS, **{BEST_TRAIN_OFFERS_SORTING.value: BEST_TRAIN_OFFERS_SORTING})
DEFAULT_SORTING = BEST_TRAIN_OFFERS_SORTING
