# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from sqlalchemy import Column, Integer, Date, UniqueConstraint, DateTime, JSON

from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.db_models.base import Base


class DirectionTariffInfo(Base):

    __tablename__ = 'direction_tariff_info'

    id = Column(Integer, primary_key=True)

    departure_point_express_id = Column(Integer, nullable=False)
    arrival_point_express_id = Column(Integer, nullable=False)
    departure_date = Column(Date, nullable=False)

    data = Column(JSON, nullable=False)

    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)

    __table_args__ = (
        UniqueConstraint(
            'departure_point_express_id',
            'arrival_point_express_id',
            'departure_date',
            name='direction_tariff_info_uniq'
        ),
    )
