# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from sqlalchemy import Column, Integer, UniqueConstraint, DateTime, String, ARRAY, Boolean

from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.db_models.base import Base
from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.helpers.postgres import ProtobufType
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_place_info_pb2 import TrainPlaceInfo
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_tariff_info_pb2 import TrainTariffInfo


TrainInfoUniqueConstraint = UniqueConstraint(
    'departure_point_express_id',
    'arrival_point_express_id',
    'departure_at',
    'number',
    name='train_info_uniq'
)


class TrainInfo(Base):
    __tablename__ = 'train_info'

    id = Column(Integer, primary_key=True)

    departure_point_express_id = Column(Integer, nullable=False)
    arrival_point_express_id = Column(Integer, nullable=False)
    departure_at = Column(DateTime, nullable=False)
    number = Column(String, nullable=False)

    tariffs_info = Column(ProtobufType(TrainTariffInfo), nullable=False)
    places_info = Column(ProtobufType(TrainPlaceInfo), nullable=False)
    facilities_ids = Column(ARRAY(Integer))
    electronic_ticket = Column(Boolean, nullable=True)

    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)

    __table_args__ = (
        TrainInfoUniqueConstraint,
    )
