# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from sqlalchemy import TypeDecorator
from sqlalchemy.dialects.postgresql import BYTEA


class ProtobufType(TypeDecorator):
    """
    Protobuf type field
    """

    impl = BYTEA

    def __init__(self, protobuf_class, *args, **kwargs):
        super(ProtobufType, self).__init__(*args, **kwargs)
        self.protobuf_class = protobuf_class

    def process_bind_param(self, value, dialect):
        return value.SerializeToString()

    def process_result_value(self, value, dialect):
        return self.protobuf_class.FromString(value)
