# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from bisect import bisect_right
from datetime import datetime  # noqa: UnusedImport
from typing import Optional, Tuple  # noqa: UnusedImport


class TariffDirectionUpdatedInfoRecord(object):
    def __init__(self, left_border, right_border, updated_at):
        # type: (datetime, datetime, Optional[datetime]) -> None
        self.left_border = left_border
        self.right_border = right_border
        self.updated_at = updated_at

    def __repr__(self):
        return (
            '<TariffDirectionUpdatedInfoRecord'
            ' left_border={self.left_border!r} right_border={self.right_border!r} updated_at={self.updated_at!r}'
            '>'.format(self=self)
        )


class TariffDirectionUpdatedInfo(object):
    def __init__(self, records):
        # type: (Tuple[TariffDirectionUpdatedInfoRecord, ...]) -> None
        self.records = records
        self.borders = tuple(r.left_border for r in self.records)

    def __repr__(self):
        return '<TariffDirectionUpdatedInfo records={self.records!r} borders={self.borders!r}>'.format(self=self)

    def get_updated_at(self, segment_dt):
        # type: (datetime) -> Optional[datetime]
        if not self.records:
            return None

        record = self.records[bisect_right(self.borders, segment_dt) - 1]  # type: TariffDirectionUpdatedInfoRecord
        return record.updated_at if record.left_border <= segment_dt <= record.right_border else None
