# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from opentracing_instrumentation import traced_function
from sqlalchemy.dialects import postgresql

from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.db_models import DirectionTariffInfo
from travel.rasp.wizards.train_wizard_api.lib.storage_store import StorageStore, storage_store  # noqa: UnusedImport


class TariffDirectionInfoSaver(object):

    def __init__(self, storage_store):
        # type: (StorageStore) -> None
        self._storage_store = storage_store

    @traced_function(name='train_wizard_api.lib.pgaas_price_store.tariff_direction_info_saver.TariffDirectionInfoSaver.save')
    def save(self, info):
        stmt = postgresql.insert(DirectionTariffInfo).values([info])
        updated_values = {
            'updated_at': stmt.excluded.updated_at,
            'data': stmt.excluded.data,
        }
        update_stmt = stmt.on_conflict_do_update(
            constraint='direction_tariff_info_uniq',
            set_=updated_values,
        )

        with self._storage_store.get('master').get_engine().connect() as conn:
            conn.execute(update_stmt)


tariff_direction_info_saver = TariffDirectionInfoSaver(
    storage_store=storage_store
)
