# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import Tuple  # noqa: UnusedImport

from sqlalchemy.dialects import postgresql

from travel.rasp.library.python.common23.date import environment
from common.utils.date import UTC_TZ
from travel.library.python.tracing.instrumentation import traced_function
from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.db_models.train_info import (
    TrainInfo,
    TrainInfoUniqueConstraint
)
from travel.rasp.wizards.train_wizard_api.lib.storage_store import StorageStore, storage_store  # noqa: UnusedImport
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_place_info_pb2 import TrainPlaceInfo  # noqa: UnusedImport
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_tariff_info_pb2 import TrainTariffInfo  # noqa: UnusedImport


class TrainInfoSaver(object):
    def __init__(self, storage_store, environment):
        # type: (StorageStore, any) -> None
        self._storage_store = storage_store
        self._environment = environment

    @traced_function(name='train_wizard_api.lib.pgaas_price_store.tariff_info_saver.TrainInfoSaver.save')
    def save(self, query, tariffs_info, places_info, facilities_ids, electronic_ticket):
        # type: (dict, TrainTariffInfo, TrainPlaceInfo, Tuple[int, ...], bool) -> None
        now = self._environment.now_utc()
        stmt = postgresql.insert(TrainInfo).values([
            {
                'departure_point_express_id': query['departure_point_express_id'],
                'arrival_point_express_id': query['arrival_point_express_id'],
                'departure_at': query['departure_at'].astimezone(UTC_TZ).replace(tzinfo=None),
                'number': query['number'],
                'created_at': now,
                'updated_at': now,
                'tariffs_info': tariffs_info,
                'places_info': places_info,
                'facilities_ids': facilities_ids,
                'electronic_ticket': electronic_ticket
            }
        ])
        update_stmt = stmt.on_conflict_do_update(
            constraint=TrainInfoUniqueConstraint.name,
            set_={
                'updated_at': stmt.excluded.updated_at,
                'tariffs_info': stmt.excluded.tariffs_info,
                'places_info': stmt.excluded.places_info,
                'facilities_ids': stmt.excluded.facilities_ids,
                'electronic_ticket': electronic_ticket
            },
        )

        with self._storage_store.get('master').get_engine().connect() as connection:
            connection.execute(update_stmt)


train_info_saver = TrainInfoSaver(
    storage_store=storage_store,
    environment=environment
)
