# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import Tuple  # noqa: UnusedImport

from travel.rasp.wizards.train_wizard_api.lib.facility_provider import FacilityProvider, facility_provider  # noqa: UnusedImport
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_place_info_pb2 import TrainPlaceInfo  # noqa: UnusedImport


class TrainFacilityFabric(object):
    def __init__(self, facility_provider):
        # type: (FacilityProvider) -> None
        self._facility_provider = facility_provider

    def get_facilities_ids(self, place_info):
        # type: (TrainPlaceInfo) -> Tuple[int, ...]
        facilities = set()
        for place in place_info.places:
            for facility_id in place.facilities_ids:
                facilities.add(facility_id)
        return tuple(sorted({
            f for f in facilities
            if self._facility_provider.get_code_by(f) is not None
        }))


train_facility_fabric = TrainFacilityFabric(
    facility_provider=facility_provider
)
