# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from logging import Logger, getLogger  # noqa: UnusedImport

from travel.rasp.wizards.train_wizard_api.protobuf_models.train_place_info_pb2 import TrainPlace, TrainPlaceInfo
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_price_pb2 import Price


class TrainInfoParser(object):
    """
    Преобразуем грязную информацию о поезде по вагонам в информацию о каждом месте для дальнейшей обработки
    """

    def __init__(self, logger):
        # type: (Logger) -> None
        self._logger = logger

    def parse(self, raw_coaches):
        places = []

        for coach in raw_coaches:
            coach_type_id = coach['type_id']
            coach_facilities = coach['facilities_ids']
            company_id = coach['company_id'] or 0
            coach_number = int(coach['number'])
            coach_errors = coach['errors']

            for raw_place in coach['places']:
                place_facilities = raw_place.get('facilities_ids', [])
                value = int(round(raw_place['price']['value']))
                currency_id = 0  # todo fix it
                places.append(TrainPlace(
                    coach_number=coach_number,
                    group=int(raw_place.get('group_number', 0)),
                    number=str(raw_place['number']),
                    coach_type_id=coach_type_id,
                    company_id=company_id,
                    facilities_ids=tuple(sorted(set(place_facilities + coach_facilities))),
                    price=Price(
                        value=value,
                        base_value=value,
                        currency_id=currency_id,
                    ),
                    coach_errors=coach_errors,
                ))

        return TrainPlaceInfo(
            places=places
        )


train_info_parser = TrainInfoParser(
    logger=getLogger(__name__)
)
