# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.wizards.train_wizard_api.protobuf_models.train_place_info_pb2 import TrainPlaceInfo  # noqa: UnusedImport
from travel.rasp.wizards.train_wizard_api.protobuf_models.train_tariff_info_pb2 import TrainTariffInfo, TrainTariff


class TrainTariffFabric(object):
    def _tariff_key(self, place):
        return (
            place.coach_number,
            place.coach_type_id,
            place.company_id,
            tuple(place.facilities_ids),
            place.price.value,
            place.price.currency_id
        )

    def make_tariffs_info(self, places_info):
        # type: (TrainPlaceInfo) -> TrainTariffInfo
        tariff_to_place_info = {}

        for place in places_info.places:
            key = self._tariff_key(place)
            if key not in tariff_to_place_info:
                tariff_to_place_info[key] = {
                    'place': place,
                    'seats': 0,
                }
            tariff_to_place_info[key]['seats'] += 1

        return TrainTariffInfo(tariffs=[
            TrainTariff(
                coach_number=place_info['place'].coach_number,
                coach_type_id=place_info['place'].coach_type_id,
                company_id=place_info['place'].company_id,
                facilities_ids=place_info['place'].facilities_ids,
                price=place_info['place'].price,
                coach_errors=place_info['place'].coach_errors,
                seats=place_info['seats'],
            ) for _, place_info in sorted(tariff_to_place_info.items(), key=lambda x: x[0])
        ])


train_tariff_fabric = TrainTariffFabric()
