# coding: utf-8

from django.conf import settings
from django.core.management.base import BaseCommand

from travel.rasp.library.python.common23.data_api.dbaas.client import HostInfo
from travel.rasp.library.python.common23.data_api.dbaas.instance import dbaas_client
from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.db_models.base import Base
from travel.rasp.wizards.train_wizard_api.lib.storage_store import storage_store


class Command(BaseCommand):
    help = """Apply migration for postgres db"""

    def handle(self, *args, **options):
        if settings.DBAAS_TRAIN_WIZARD_API_DB_HOST is None:
            db_hosts = dbaas_client.get_hosts(
                cluster_id=settings.DBAAS_TRAIN_WIZARD_API_DB_CLUSTER_ID
            )
        else:
            db_hosts = [HostInfo(settings.DBAAS_TRAIN_WIZARD_API_DB_HOST, 'xxx')]
        storage = storage_store.init(db_hosts, alias='master', allow_read_only=False, logging=True)
        engine = storage.get_engine()
        Base.metadata.create_all(engine)
