# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime
from random import randint, shuffle

from travel.rasp.wizards.train_wizard_api.lib.express_system_provider import ExpressSystemProvider, express_system_provider  # noqa: UnusedImport


class FakeSegmentFabric(object):

    def __init__(self, express_system_provider):
        # type: (ExpressSystemProvider) -> None
        self._express_system_provider = express_system_provider

    def make(self, from_point, to_point, when, segments):
        from_point_express_id = self._express_system_provider.find_express_id(from_point.point_key)
        to_point_express_id = self._express_system_provider.find_express_id(to_point.point_key)

        if from_point_express_id is None:
            return
        if to_point_express_id is None:
            return

        today = datetime.now()

        return {
            'departure_point_express_id': from_point_express_id,
            'arrival_point_express_id': to_point_express_id,
            'departure_date': when,
            'created_at': today,
            'updated_at': today,
            'data': [
                {
                    'arrival_dt': s.arrival_local_dt.isoformat(),
                    'arrival_station_id': s.arrival_station.id,
                    'departure_dt': s.departure_local_dt.isoformat(),
                    'departure_station_id': s.departure_station.id,
                    'number': s.train_number,
                    'display_number': s.display_number,
                    'has_dynamic_pricing': s.has_dynamic_pricing,
                    'two_storey': s.two_storey,
                    'is_suburban': s.is_suburban,
                    'coach_owners': s.coach_owners,
                    'places': self.make_places(),
                    'title_dict': 'some_string'
                }
                for s in segments
            ]
        }

    def make_places(self):
        coach_types = ['soft', 'platzkarte', 'compartment', 'suite', 'common', 'sitting']
        shuffle(coach_types)
        return [
            {
                'coach_type': coach_types[i],
                'count': randint(1, 4),
                'price': {
                    'currency': 'RUR',
                    'value': randint(500, 20000)
                }
            } for i in range(3)
        ]


segment_fabric = FakeSegmentFabric(
    express_system_provider=express_system_provider
)
