# -*- coding: utf-8 -*-

from django.conf import settings
from django.conf.urls import url
from django.conf.urls.static import static

from travel.rasp.wizards.train_wizard_api.views.direction import direction_view
from travel.rasp.wizards.train_wizard_api.views.open_direction import open_direction_view
from travel.rasp.wizards.train_wizard_api.views.legacy_direction import legacy_direction_view
from travel.rasp.wizards.train_wizard_api.views.direction_places import direction_places_view
from travel.rasp.wizards.train_wizard_api.views.prices import index_view
from travel.rasp.wizards.train_wizard_api.views.prices_by_directions import prices_by_directions
from travel.rasp.wizards.train_wizard_api.views.index_train import index_train_view
from travel.rasp.wizards.wizard_lib.views.ping import ping_view
from travel.rasp.wizards.wizard_lib.views.version import version_view

urlpatterns = [
    url(r'^searcher/api/direction/$', direction_view),
    url(r'^searcher/api/open_direction/$', open_direction_view),
    url(r'^searcher/api/legacy_direction/$', legacy_direction_view),
    url(r'^searcher/api/direction_places/$', direction_places_view),
    url(r'^searcher/public-api/direction/$', direction_view),  # FIXME
    url(r'^searcher/public-api/open_direction/$', open_direction_view),  # FIXME
    url(r'^searcher/public-api/legacy_direction/$', legacy_direction_view),  # FIXME
    url(r'^searcher/public-api/direction_places/$', direction_places_view),  # FIXME
    url(r'^searcher/public-api/ping/$', ping_view),
    url(r'^searcher/public-api/version/$', version_view),
    url(r'^searcher/api/prices_by_directions/$', prices_by_directions),  # FIXME
    url(r'^searcher/public-api/prices_by_directions/$', prices_by_directions),
]

urlpatterns += [
    url(r'^indexer/api/direction/$', index_view),
    url(r'^indexer/api/train/$', index_train_view),
    url(r'^indexer/public-api/direction/$', index_view),  # FIXME
    url(r'^indexer/public-api/train/$', index_train_view),  # FIXME
    url(r'^indexer/public-api/ping/$', ping_view),
    url(r'^indexer/public-api/version/$', version_view),
]

urlpatterns += [
    url(r'^public-api/direction_places/$', ping_view),
]

urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
