# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rest_framework import status
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.library.python.tracing.instrumentation import child_span
from travel.rasp.wizards.train_wizard_api.lib.pgaas_price_store.tariff_direction_info_provider import tariff_direction_info_provider
from travel.rasp.wizards.train_wizard_api.serialization.prices_by_directions import TariffsByDirectionQuerySchema, dump_tariff_info
from travel.rasp.wizards.wizard_lib.views.helpers.error_handlers import log_validation_error


@api_view()
@log_validation_error
def prices_by_directions(request):
    with child_span('train_wizard_api.views.prices_by_direction.prices_by_directions::TariffsByDirectionQuerySchema.load'):
        query, errors = TariffsByDirectionQuerySchema(strict=True).load(request.query_params)

    tariff_direction_info = tariff_direction_info_provider.find_tariffs_by_directions(
        query.directions, query.departure_date_from, query.departure_date_to
    )
    if not tariff_direction_info:
        return Response([], status=status.HTTP_204_NO_CONTENT)

    with child_span('train_wizard_api.views.prices_by_direction.prices_by_directions::make_Response'):
        return Response([dump_tariff_info(ti, query.tld) for ti in tariff_direction_info])
