PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/django-opentracing
    contrib/python/djangorestframework
    contrib/python/Flask
    contrib/python/geoindex
    contrib/python/httpretty
    contrib/python/jaeger-client
    contrib/python/opentracing-instrumentation
    contrib/python/python-json-logger
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/ujson

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation

    travel/rasp/library/python/common
    travel/rasp/library/python/geosearch
    travel/library/python/entrypoint
    travel/rasp/wizards/train_wizard_api/protobuf_models
    travel/rasp/wizards/wizard_lib
)

PY_SRCS(
    __init__.py
    app.py

    direction/filters/__init__.py
    direction/filters/brand_filter.py
    direction/filters/coach_type_filter.py
    direction/filters/facility_filter.py
    direction/filters/place_count_filter.py
    direction/filters/price_filter.py
    direction/__init__.py
    direction/logger.py
    direction/promotion.py
    direction/schedule_cache.py
    direction/segments.py
    direction/sorting.py

    gunicorn_conf.py

    lib/__init__.py
    lib/express_system_provider.py
    lib/facility_provider.py
    lib/first_equal_predicate.py
    lib/optimal_direction_provider.py
    lib/pgaas_price_store/db_models/__init__.py
    lib/pgaas_price_store/db_models/base.py
    lib/pgaas_price_store/db_models/direction_tariff_info.py
    lib/pgaas_price_store/db_models/train_info.py
    lib/pgaas_price_store/helpers/__init__.py
    lib/pgaas_price_store/helpers/postgres.py
    lib/pgaas_price_store/__init__.py
    lib/pgaas_price_store/models/__init__.py
    lib/pgaas_price_store/models/place.py
    lib/pgaas_price_store/models/tariff_direction_info.py
    lib/pgaas_price_store/models/tariff_direction_updated_info.py
    lib/pgaas_price_store/tariff_direction_info_provider.py
    lib/pgaas_price_store/tariff_direction_info_saver.py
    lib/pgaas_price_store/train_info_provider.py
    lib/pgaas_price_store/train_info_saver.py
    lib/storage_store.py
    lib/storage_timed_execute.py
    lib/tests_utils.py
    lib/train_city_provider.py
    lib/train_facility_fabric.py
    lib/train_info_parser.py
    lib/train_tariff_fabric.py
    lib/url_factories.py

    management/commands/__init__.py
    management/commands/postgresql_migrate.py
    management/__init__.py

    serialization/__init__.py
    serialization/direction_places.py
    serialization/direction.py
    serialization/legacy_direction.py
    serialization/open_direction.py
    serialization/prices_by_directions.py
    serialization/route.py

    settings/__init__.py
    settings/dbaas.py

    tools/__init__.py
    tools/fake_segment_fabric.py

    urls/__init__.py

    views/__init__.py
    views/direction_places.py
    views/direction.py
    views/index_train.py
    views/legacy_direction.py
    views/open_direction.py
    views/prices_by_directions.py
    views/prices.py

    wsgi.py
)

NO_LINT(
    docker/local_settings/__init__.py
)

RESOURCE_FILES(
    PREFIX travel/rasp/wizards/train_wizard_api
    direction/texts.j2
    direction/texts_radius.j2
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)


