# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.library.python.tracing.instrumentation import child_span, traced_function


def _get_departure_date(raw_segment):
    departure_dt = raw_segment.departure_dt
    departure_station = raw_segment.departure_station
    return departure_dt.astimezone(departure_station.pytz).date()


@traced_function
def find_schedule_segments(schedule_cache, departure_point, arrival_point, event_date_query, thread_predicate=None):
    with child_span('wizard_lib.direction.segments.find_schedule_segments::find_segments'):
        found_segments = schedule_cache.find_segments(
            departure_point, arrival_point, event_date_query.min_event_dt, thread_predicate=thread_predicate
        )
        raw_segments = tuple(event_date_query.raw_filter_func(found_segments))
    found_departure_date = _get_departure_date(raw_segments[0]) if raw_segments else None
    return found_departure_date, raw_segments
