# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple
from functools import partial


Sorting = namedtuple('Sorting', ('value', 'apply',))


def _noop(segments):
    return segments


def _build_sortings(sorting_keys):
    for value, sorting_key in sorting_keys.items():
        for reverse in (False, True):
            sorting_func = (partial(sorted, key=sorting_key, reverse=reverse) if sorting_key is not None else
                            reversed if reverse else
                            _noop)
            yield Sorting('-{}'.format(value) if reverse else value, sorting_func)


SEGMENT_SORTING_KEYS = {
    'departure': None,
    'arrival': lambda v: v.segment.arrival_local_dt,
    'duration': lambda v: v.segment.duration,
    'price': lambda v: v.places_group.price.value if v.places_group else float('inf'),
}
SORTINGS = {sorting.value: sorting for sorting in _build_sortings(SEGMENT_SORTING_KEYS)}
DEFAULT_SORTING = SORTINGS['departure']
