# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from enum import Enum


class ExperimentFlag(Enum):
    # Поиск между ближайшими вокзалами
    EXPERIMENTAL_SEARCH = 'RASPWIZARDS-557'
    # Поиск между ближайшими вокзалами в радиусах 20, 50, 70
    EXPERIMENTAL_SEARCH_20KM = 'RASPWIZARDS-715-20km'
    EXPERIMENTAL_SEARCH_50KM = 'RASPWIZARDS-715-50km'
    EXPERIMENTAL_SEARCH_70KM = 'RASPWIZARDS-715-70km'
    # Ссылка на сегодня в колдунщике электричек по станции для тача
    SUBURBAN_STATION_TOUCH_TODAY_URL = 'RASPWIZARDS-594'
    # В колдунщике электричек всегда считаем что местное время московское
    SUBURBAN_STATION_HACKED_FUTURE = 'RASPWIZARDS-600'
    # Поиск аэроэкспрессов в обоих направлениях
    BIDIRECTIONAL_AEROEXPRESS = 'RASPWIZARDS-598'
    # Возвращать сегменты во вкладке «все направления»
    SUBURBAN_STATION_ALL_DIRECTION_SEGMENTS = 'RASPWIZARDS-622'
    # Ссылка на поиск ближайших рейсов в колдунщике по направлению
    DIRECTION_SEARCH_NEXT_URL = 'RASPWIZARDS-604'
    # Для тестирования разбора флагов
    DUMMY_FLAG = 'DUMMY_FLAG'
    # Лучшие предложения для поездов: фирменные и самые быстрые
    BEST_OFFERS_BRAND = 'RASPWIZARDS-636-brand'
    BEST_OFFERS_DURATION = 'RASPWIZARDS-636-duration'
    # Перенаправить запросы на trains
    TRAIN_LINK_ALL = 'RASPWIZARDS-627-all'
    TRAIN_LINK_BUY_INTENT = 'RASPWIZARDS-627-buy-intent'
    # Отвечать ОТК на запросы без пункта отправления или прибытия
    TRAIN_ANSWER_POINTLESS_QUERY = 'RASPWIZARDS-704'
    # Флаги для включения определенных типов колдунщиков
    ENABLE_DIRECTION_WIZARD = 'RASPWIZARDS-ENABLE-DIRECTION'
    ENABLE_STATION_WIZARD = 'RASPWIZARDS-ENABLE-STATION'
    ENABLE_ROUTE_WIZARD = 'RASPWIZARDS-ENABLE-ROUTE'
    ENABLE_GENERAL_WIZARD = 'RASPWIZARDS-ENABLE-GENERAL'
