# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from enum import Enum


class GeobaseRegionType(Enum):
    DELETED = -1              # Скрытый регион.
    OTHER = 0                 # Прочие регионы.
    CONTINENT = 1             # Континент.
    SUBCONTINENT = 2          # Регион.
    COUNTRY = 3               # Страна.
    FEDERAL_DISTRICT = 4      # Федеральный округ.
    REGION = 5                # Субъект Федерации
    CITY = 6                  # Город.
    VILLAGE = 7               # Село.
    CITY_DISTRICT = 8         # Район города.
    METRO_STATION = 9         # Станция метро.
    DISTRICT = 10             # Район субъекта федерации.
    AIRPORT = 11              # Аэропорт.
    FOREIGN_TERRITORY = 12    # Заморская территория.
    SECOND_DISTRICT = 13      # Район города второго уровня.
    MONORAIL_STATION = 14     # Станция монорельса.
    RURAL_SETTLEMENT = 15     # Сельское поселение
    UNIVERSAL = 99            # Универсальный тип.


LikeSettlementTypesIds = {
    GeobaseRegionType.CITY,
    GeobaseRegionType.VILLAGE,
}
